//
// Created by sachetto on 19/03/2021.
//

#ifndef MONOALG3D_C_EXTRA_DATA_HELPER_FUNCTIONS_H
#define MONOALG3D_C_EXTRA_DATA_HELPER_FUNCTIONS_H

#include <unistd.h>
#include "../common_types/common_types.h"
#include "../config/config_common.h"

#define SET_EXTRA_DATA_SIZE(value) *extra_data_size = (value)

struct extra_data_for_HCM {
	
    real INaFactor;
    real ICaLFactor;
    real Ko;
    real f;
	
    real *HCMRE;
	int *CELLT;
	real *ISCH;
	real *APEXB;
	int *FIB;
	
	real modelID;
	
	real mCaL;
    real mNa;
    real mto;
    real mNaL;
    real mKr;
    real mKs;
    real mK1;
    real mNaCa;
    real mNaK;
    real mRel;
    real mUp;
	
	real *ctrlNormEndo;
    real *ctrlIschEndo;
    real *hcmNormEndo;
    real *hcmIschEndo;
	
	real *ctrlNormEpi;
    real *ctrlIschEpi;
    real *hcmNormEpi;
    real *hcmIschEpi;

};

struct extra_data_for_fibrosis {
    real atpi;
    real Ko;
    real Ki;
    real GNa_multiplicator;
    real GCaL_multiplicator;
    real INaCa_multiplicator;
    real Vm_modifier;
    real *fibrosis;
};

struct extra_data_for_fibrosis * set_common_schemia_data(struct config *config, uint32_t num_cells);

struct extra_data_for_HCM * set_HCM_data(struct config *config, uint32_t num_cells);

struct extra_data_for_torord {
    real INa_Multiplier; 
    real ICaL_Multiplier;
    real Ito_Multiplier;
    real INaL_Multiplier;
    real IKr_Multiplier; 
    real IKs_Multiplier; 
    real IK1_Multiplier; 
    real IKb_Multiplier; 
    real INaCa_Multiplier;
    real INaK_Multiplier;  
    real INab_Multiplier;  
    real ICab_Multiplier;  
    real IpCa_Multiplier;  
    real ICaCl_Multiplier;
    real IClb_Multiplier; 
    real Jrel_Multiplier; 
    real Jup_Multiplier;
    real *initial_ss_endo;
    real *initial_ss_epi;
    real *initial_ss_mid;
    real *transmurality;
};

#endif // MONOALG3D_C_EXTRA_DATA_HELPER_FUNCTIONS_H
